<?php //830d6d7208b3f650e5966e8406020331
/** @noinspection all */

namespace App\Models {

    use Database\Factories\AdminFactory;
    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Admin_C;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Brand_C;
    use LaravelIdea\Helper\App\Models\_IH_Brand_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_CronJobLog_C;
    use LaravelIdea\Helper\App\Models\_IH_CronJobLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_CustomDomain_C;
    use LaravelIdea\Helper\App\Models\_IH_CustomDomain_QB;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_C;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_QB;
    use LaravelIdea\Helper\App\Models\_IH_Menu_C;
    use LaravelIdea\Helper\App\Models\_IH_Menu_QB;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_C;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_Newsletter_C;
    use LaravelIdea\Helper\App\Models\_IH_Newsletter_QB;
    use LaravelIdea\Helper\App\Models\_IH_OrderProducts_C;
    use LaravelIdea\Helper\App\Models\_IH_OrderProducts_QB;
    use LaravelIdea\Helper\App\Models\_IH_Order_C;
    use LaravelIdea\Helper\App\Models\_IH_Order_QB;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_Page_C;
    use LaravelIdea\Helper\App\Models\_IH_Page_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogs_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogs_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlanFeature_C;
    use LaravelIdea\Helper\App\Models\_IH_PlanFeature_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlanPaymentGateway_C;
    use LaravelIdea\Helper\App\Models\_IH_PlanPaymentGateway_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlanTheme_C;
    use LaravelIdea\Helper\App\Models\_IH_PlanTheme_QB;
    use LaravelIdea\Helper\App\Models\_IH_PricePlan_C;
    use LaravelIdea\Helper\App\Models\_IH_PricePlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProductOrder_C;
    use LaravelIdea\Helper\App\Models\_IH_ProductOrder_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProductReviews_C;
    use LaravelIdea\Helper\App\Models\_IH_ProductReviews_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProductWishlist_C;
    use LaravelIdea\Helper\App\Models\_IH_ProductWishlist_QB;
    use LaravelIdea\Helper\App\Models\_IH_StaticOptionCentral_C;
    use LaravelIdea\Helper\App\Models\_IH_StaticOptionCentral_QB;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_C;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_QB;
    use LaravelIdea\Helper\App\Models\_IH_Status_C;
    use LaravelIdea\Helper\App\Models\_IH_Status_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportDepartment_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportDepartment_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicketMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicketMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicket_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicket_QB;
    use LaravelIdea\Helper\App\Models\_IH_TenantException_C;
    use LaravelIdea\Helper\App\Models\_IH_TenantException_QB;
    use LaravelIdea\Helper\App\Models\_IH_TenantUniqueKey_C;
    use LaravelIdea\Helper\App\Models\_IH_TenantUniqueKey_QB;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_C;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_QB;
    use LaravelIdea\Helper\App\Models\_IH_Testimonial_C;
    use LaravelIdea\Helper\App\Models\_IH_Testimonial_QB;
    use LaravelIdea\Helper\App\Models\_IH_Themes_C;
    use LaravelIdea\Helper\App\Models\_IH_Themes_QB;
    use LaravelIdea\Helper\App\Models\_IH_TopbarInfo_C;
    use LaravelIdea\Helper\App\Models\_IH_TopbarInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserDeliveryAddress_C;
    use LaravelIdea\Helper\App\Models\_IH_UserDeliveryAddress_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserDomain_C;
    use LaravelIdea\Helper\App\Models\_IH_UserDomain_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_Widgets_C;
    use LaravelIdea\Helper\App\Models\_IH_Widgets_QB;
    use LaravelIdea\Helper\App\Models\_IH_ZeroPricePlanHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_ZeroPricePlanHistory_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Modules\Campaign\Entities\_IH_CampaignProduct_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    use LaravelIdea\Helper\Modules\Product\Entities\_IH_Product_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_UserShippingAddress_QB;
    use LaravelIdea\Helper\Modules\SmsGateway\Entities\_IH_UserOtp_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_QB;
    use Modules\Campaign\Entities\CampaignProduct;
    use Modules\CountryManage\Entities\City;
    use Modules\CountryManage\Entities\Country;
    use Modules\CountryManage\Entities\State;
    use Modules\Product\Entities\Product;
    use Modules\ShippingModule\Entities\UserShippingAddress;
    use Modules\SmsGateway\Entities\UserOtp;
    use Modules\Wallet\Entities\Wallet;
    use Modules\Wallet\Entities\WalletTenantList;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    use Stancl\Tenancy\Database\Models\Domain;
    
    /**
     * @property int $id
     * @property string $name
     * @property string $username
     * @property int $email_verified
     * @property string|null $email_verify_token
     * @property string|null $mobile
     * @property string $email
     * @property int|null $image
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all()
     * @foreignLinks id,\Modules\Campaign\Entities\Campaign,admin_id|id,\App\Models\SupportTicket,admin_id|id,\Modules\Blog\Entities\Blog,admin_id|id,\Modules\RefundModule\Entities\RefundChat,admin_id
     * @mixin _IH_Admin_QB
     * @method static AdminFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property string|null $url
     * @property string|null $image
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $name
     * @property string $slug
     * @property int $image_id
     * @property int $banner_id
     * @property string|null $title
     * @property string|null $description
     * @property Carbon|null $deleted_at
     * @property MediaUploader $getImage
     * @method HasOne|_IH_MediaUploader_QB getImage()
     * @method static _IH_Brand_QB onWriteConnection()
     * @method _IH_Brand_QB newQuery()
     * @method static _IH_Brand_QB on(null|string $connection = null)
     * @method static _IH_Brand_QB query()
     * @method static _IH_Brand_QB with(array|string $relations)
     * @method _IH_Brand_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brand_C|Brand[] all()
     * @foreignLinks id,\Modules\Product\Entities\Product,brand_id
     * @mixin _IH_Brand_QB
     */
    class Brand extends Model {}
    
    /**
     * @property int $id
     * @property int $form_builder_id
     * @property string|null $fields
     * @property string|null $attachment
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property FormBuilder $form
     * @method BelongsTo|_IH_FormBuilder_QB form()
     * @method static _IH_ContactMessage_QB onWriteConnection()
     * @method _IH_ContactMessage_QB newQuery()
     * @method static _IH_ContactMessage_QB on(null|string $connection = null)
     * @method static _IH_ContactMessage_QB query()
     * @method static _IH_ContactMessage_QB with(array|string $relations)
     * @method _IH_ContactMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactMessage_C|ContactMessage[] all()
     * @ownLinks form_builder_id,\App\Models\FormBuilder,id
     * @mixin _IH_ContactMessage_QB
     */
    class ContactMessage extends Model {}
    
    /**
     * @property int $id
     * @property int|null $cronjob_id
     * @property string|null $title
     * @property string|null $type
     * @property string|null $running_qty
     * @property string|null $others
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CronJobLog_QB onWriteConnection()
     * @method _IH_CronJobLog_QB newQuery()
     * @method static _IH_CronJobLog_QB on(null|string $connection = null)
     * @method static _IH_CronJobLog_QB query()
     * @method static _IH_CronJobLog_QB with(array|string $relations)
     * @method _IH_CronJobLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CronJobLog_C|CronJobLog[] all()
     * @mixin _IH_CronJobLog_QB
     */
    class CronJobLog extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $custom_domain
     * @property string|null $custom_domain_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $unique_key
     * @property string|null $old_domain
     * @property Tenant|null $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CustomDomain_QB onWriteConnection()
     * @method _IH_CustomDomain_QB newQuery()
     * @method static _IH_CustomDomain_QB on(null|string $connection = null)
     * @method static _IH_CustomDomain_QB query()
     * @method static _IH_CustomDomain_QB with(array|string $relations)
     * @method _IH_CustomDomain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomDomain_C|CustomDomain[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_CustomDomain_QB
     */
    class CustomDomain extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $email
     * @property string|null $button_text
     * @property string|null $fields
     * @property string|null $success_message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FormBuilder_QB onWriteConnection()
     * @method _IH_FormBuilder_QB newQuery()
     * @method static _IH_FormBuilder_QB on(null|string $connection = null)
     * @method static _IH_FormBuilder_QB query()
     * @method static _IH_FormBuilder_QB with(array|string $relations)
     * @method _IH_FormBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FormBuilder_C|FormBuilder[] all()
     * @foreignLinks id,\App\Models\ContactMessage,form_builder_id
     * @mixin _IH_FormBuilder_QB
     */
    class FormBuilder extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property int $direction
     * @property int $status
     * @property int $default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @foreignLinks id,\Modules\DigitalProduct\Entities\DigitalProductLanguage,language_id
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $path
     * @property string|null $alt
     * @property string|null $size
     * @property int $user_type
     * @property int $user_id
     * @property string|null $dimensions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MediaUploader_QB onWriteConnection()
     * @method _IH_MediaUploader_QB newQuery()
     * @method static _IH_MediaUploader_QB on(null|string $connection = null)
     * @method static _IH_MediaUploader_QB query()
     * @method static _IH_MediaUploader_QB with(array|string $relations)
     * @method _IH_MediaUploader_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MediaUploader_C|MediaUploader[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_MediaUploader_QB
     */
    class MediaUploader extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $content
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all()
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $description
     * @property string|null $image
     * @property string|null $fb_title
     * @property string|null $fb_description
     * @property string|null $fb_image
     * @property string|null $tw_title
     * @property string|null $tw_description
     * @property string|null $tw_image
     * @property int $metainfoable_id
     * @property string $metainfoable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $metainfoable
     * @method MorphTo metainfoable()
     * @method static _IH_MetaInfo_QB onWriteConnection()
     * @method _IH_MetaInfo_QB newQuery()
     * @method static _IH_MetaInfo_QB on(null|string $connection = null)
     * @method static _IH_MetaInfo_QB query()
     * @method static _IH_MetaInfo_QB with(array|string $relations)
     * @method _IH_MetaInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MetaInfo_C|MetaInfo[] all()
     * @mixin _IH_MetaInfo_QB
     */
    class MetaInfo extends Model {}
    
    /**
     * @property int $id
     * @property string $email
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $token
     * @property string|null $verified
     * @method static _IH_Newsletter_QB onWriteConnection()
     * @method _IH_Newsletter_QB newQuery()
     * @method static _IH_Newsletter_QB on(null|string $connection = null)
     * @method static _IH_Newsletter_QB query()
     * @method static _IH_Newsletter_QB with(array|string $relations)
     * @method _IH_Newsletter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Newsletter_C|Newsletter[] all()
     * @mixin _IH_Newsletter_QB
     */
    class Newsletter extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $checkout_type
     * @property string $status
     * @property string $payment_status
     * @property string|null $package_id
     * @property string|null $package_name
     * @property string|null $package_price
     * @property string|null $custom_fields
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan|null $package
     * @method HasOne|_IH_PricePlan_QB package()
     * @property PaymentLogs $paymentlog
     * @method HasOne|_IH_PaymentLogs_QB paymentlog()
     * @property User|null $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\Modules\RefundModule\Entities\RefundProduct,order_id
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $product_id
     * @property int|null $variant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $quantity
     * @property float|null $price
     * @property int|null $product_type
     * @property int|null $user_id
     * @property CampaignProduct $campaign_product
     * @method HasOne|_IH_CampaignProduct_QB campaign_product()
     * @property ProductOrder $order
     * @method BelongsTo|_IH_ProductOrder_QB order()
     * @method static _IH_OrderProducts_QB onWriteConnection()
     * @method _IH_OrderProducts_QB newQuery()
     * @method static _IH_OrderProducts_QB on(null|string $connection = null)
     * @method static _IH_OrderProducts_QB query()
     * @method static _IH_OrderProducts_QB with(array|string $relations)
     * @method _IH_OrderProducts_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderProducts_C|OrderProducts[] all()
     * @ownLinks order_id,\App\Models\ProductOrder,id|product_id,\Modules\Product\Entities\Product,id|user_id,\App\Models\User,id
     * @mixin _IH_OrderProducts_QB
     */
    class OrderProducts extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $page_content
     * @property int $visibility
     * @property int $breadcrumb
     * @property int $page_builder
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all()
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property string|null $addon_name
     * @property string|null $addon_type
     * @property string|null $addon_location
     * @property int|null $addon_order
     * @property int|null $addon_page_id
     * @property string|null $addon_page_type
     * @property string|null $addon_settings
     * @property string|null $addon_namespace
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PageBuilder_QB onWriteConnection()
     * @method _IH_PageBuilder_QB newQuery()
     * @method static _IH_PageBuilder_QB on(null|string $connection = null)
     * @method static _IH_PageBuilder_QB query()
     * @method static _IH_PageBuilder_QB with(array|string $relations)
     * @method _IH_PageBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageBuilder_C|PageBuilder[] all()
     * @mixin _IH_PageBuilder_QB
     */
    class PageBuilder extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $image
     * @property string|null $description
     * @property int $status
     * @property int $test_mode
     * @property string $credentials
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentGateway_QB onWriteConnection()
     * @method _IH_PaymentGateway_QB newQuery()
     * @method static _IH_PaymentGateway_QB on(null|string $connection = null)
     * @method static _IH_PaymentGateway_QB query()
     * @method static _IH_PaymentGateway_QB with(array|string $relations)
     * @method _IH_PaymentGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentGateway_C|PaymentGateway[] all()
     * @mixin _IH_PaymentGateway_QB
     */
    class PaymentGateway extends Model {}
    
    /**
     * @property int $id
     * @property string|null $email
     * @property string|null $name
     * @property string|null $package_name
     * @property string|null $package_price
     * @property string|null $package_gateway
     * @property string|null $package_id
     * @property int|null $user_id
     * @property string|null $status
     * @property string|null $payment_status
     * @property string|null $transaction_id
     * @property string|null $attachments
     * @property string|null $custom_fields
     * @property string|null $track
     * @property string|null $renew_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $start_date
     * @property Carbon|null $expire_date
     * @property int|null $is_renew
     * @property string|null $tenant_id
     * @property string $theme_slug
     * @property Domain|null $domain
     * @method BelongsTo|_IH_Domain_QB domain()
     * @property PricePlan|null $package
     * @method BelongsTo|_IH_PricePlan_QB package()
     * @property _IH_PricePlan_C|PricePlan[] $price_plan
     * @property-read int $price_plan_count
     * @method HasMany|_IH_PricePlan_QB price_plan()
     * @property Tenant|null $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PaymentLogs_QB onWriteConnection()
     * @method _IH_PaymentLogs_QB newQuery()
     * @method static _IH_PaymentLogs_QB on(null|string $connection = null)
     * @method static _IH_PaymentLogs_QB query()
     * @method static _IH_PaymentLogs_QB with(array|string $relations)
     * @method _IH_PaymentLogs_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentLogs_C|PaymentLogs[] all()
     * @ownLinks user_id,\App\Models\User,id|tenant_id,\App\Models\Tenant,id
     * @mixin _IH_PaymentLogs_QB
     */
    class PaymentLogs extends Model {}
    
    /**
     * @property int $id
     * @property int $plan_id
     * @property string $feature_name
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan $plan
     * @method BelongsTo|_IH_PricePlan_QB plan()
     * @method static _IH_PlanFeature_QB onWriteConnection()
     * @method _IH_PlanFeature_QB newQuery()
     * @method static _IH_PlanFeature_QB on(null|string $connection = null)
     * @method static _IH_PlanFeature_QB query()
     * @method static _IH_PlanFeature_QB with(array|string $relations)
     * @method _IH_PlanFeature_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanFeature_C|PlanFeature[] all()
     * @mixin _IH_PlanFeature_QB
     */
    class PlanFeature extends Model {}
    
    /**
     * @property int $id
     * @property int $plan_id
     * @property string $payment_gateway_name
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan $plan
     * @method BelongsTo|_IH_PricePlan_QB plan()
     * @method static _IH_PlanPaymentGateway_QB onWriteConnection()
     * @method _IH_PlanPaymentGateway_QB newQuery()
     * @method static _IH_PlanPaymentGateway_QB on(null|string $connection = null)
     * @method static _IH_PlanPaymentGateway_QB query()
     * @method static _IH_PlanPaymentGateway_QB with(array|string $relations)
     * @method _IH_PlanPaymentGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanPaymentGateway_C|PlanPaymentGateway[] all()
     * @mixin _IH_PlanPaymentGateway_QB
     */
    class PlanPaymentGateway extends Model {}
    
    /**
     * @property int $id
     * @property int $plan_id
     * @property string $theme_slug
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan $plan
     * @method BelongsTo|_IH_PricePlan_QB plan()
     * @method static _IH_PlanTheme_QB onWriteConnection()
     * @method _IH_PlanTheme_QB newQuery()
     * @method static _IH_PlanTheme_QB on(null|string $connection = null)
     * @method static _IH_PlanTheme_QB query()
     * @method static _IH_PlanTheme_QB with(array|string $relations)
     * @method _IH_PlanTheme_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanTheme_C|PlanTheme[] all()
     * @mixin _IH_PlanTheme_QB
     */
    class PlanTheme extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int|null $type
     * @property int $status
     * @property float $price
     * @property string|null $faq
     * @property int|null $blog_permission_feature
     * @property int|null $product_permission_feature
     * @property int|null $page_permission_feature
     * @property bool $has_trial
     * @property int|null $trial_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $storage_permission_feature
     * @property string|null $package_badge
     * @property string|null $description
     * @property _IH_PlanFeature_C|PlanFeature[] $plan_features
     * @property-read int $plan_features_count
     * @method HasMany|_IH_PlanFeature_QB plan_features()
     * @property _IH_PlanPaymentGateway_C|PlanPaymentGateway[] $plan_payment_gateways
     * @property-read int $plan_payment_gateways_count
     * @method HasMany|_IH_PlanPaymentGateway_QB plan_payment_gateways()
     * @property _IH_PlanTheme_C|PlanTheme[] $plan_themes
     * @property-read int $plan_themes_count
     * @method HasMany|_IH_PlanTheme_QB plan_themes()
     * @method static _IH_PricePlan_QB onWriteConnection()
     * @method _IH_PricePlan_QB newQuery()
     * @method static _IH_PricePlan_QB on(null|string $connection = null)
     * @method static _IH_PricePlan_QB query()
     * @method static _IH_PricePlan_QB with(array|string $relations)
     * @method _IH_PricePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PricePlan_C|PricePlan[] all()
     * @mixin _IH_PricePlan_QB
     */
    class PricePlan extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $email
     * @property int|null $user_id
     * @property string $phone
     * @property string|null $country
     * @property string|null $address
     * @property string|null $city
     * @property string|null $state
     * @property string|null $zipcode
     * @property string|null $message
     * @property string|null $coupon
     * @property string|null $coupon_discounted
     * @property string|null $total_amount
     * @property string|null $status
     * @property string|null $payment_status
     * @property string|null $payment_gateway
     * @property string|null $payment_track
     * @property string|null $transaction_id
     * @property string|null $order_details
     * @property string|null $payment_meta
     * @property string|null $shipping_address_id
     * @property string|null $selected_shipping_option
     * @property string|null $checkout_type
     * @property string|null $checkout_image_path
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property City|null $getCity
     * @method HasOne|_IH_City_QB getCity()
     * @property Country|null $getCountry
     * @method HasOne|_IH_Country_QB getCountry()
     * @property State|null $getState
     * @method HasOne|_IH_State_QB getState()
     * @property UserShippingAddress|null $shipping
     * @method HasOne|_IH_UserShippingAddress_QB shipping()
     * @method static _IH_ProductOrder_QB onWriteConnection()
     * @method _IH_ProductOrder_QB newQuery()
     * @method static _IH_ProductOrder_QB on(null|string $connection = null)
     * @method static _IH_ProductOrder_QB query()
     * @method static _IH_ProductOrder_QB with(array|string $relations)
     * @method _IH_ProductOrder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductOrder_C|ProductOrder[] all()
     * @ownLinks user_id,\App\Models\User,id|shipping_address_id,\Modules\ShippingModule\Entities\ShippingAddress,id
     * @foreignLinks id,\App\Models\OrderProducts,order_id
     * @mixin _IH_ProductOrder_QB
     */
    class ProductOrder extends Model {}
    
    /**
     * @property int $id
     * @property int|null $product_id
     * @property int|null $user_id
     * @property int|null $rating
     * @property string|null $review_text
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product|null $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ProductReviews_QB onWriteConnection()
     * @method _IH_ProductReviews_QB newQuery()
     * @method static _IH_ProductReviews_QB on(null|string $connection = null)
     * @method static _IH_ProductReviews_QB query()
     * @method static _IH_ProductReviews_QB with(array|string $relations)
     * @method _IH_ProductReviews_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductReviews_C|ProductReviews[] all()
     * @ownLinks product_id,\Modules\Product\Entities\Product,id|user_id,\App\Models\User,id
     * @mixin _IH_ProductReviews_QB
     */
    class ProductReviews extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProductWishlist_QB onWriteConnection()
     * @method _IH_ProductWishlist_QB newQuery()
     * @method static _IH_ProductWishlist_QB on(null|string $connection = null)
     * @method static _IH_ProductWishlist_QB query()
     * @method static _IH_ProductWishlist_QB with(array|string $relations)
     * @method _IH_ProductWishlist_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductWishlist_C|ProductWishlist[] all()
     * @ownLinks product_id,\Modules\Product\Entities\Product,id|user_id,\App\Models\User,id
     * @mixin _IH_ProductWishlist_QB
     */
    class ProductWishlist extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_StaticOption_QB onWriteConnection()
     * @method _IH_StaticOption_QB newQuery()
     * @method static _IH_StaticOption_QB on(null|string $connection = null)
     * @method static _IH_StaticOption_QB query()
     * @method static _IH_StaticOption_QB with(array|string $relations)
     * @method _IH_StaticOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOption_C|StaticOption[] all()
     * @mixin _IH_StaticOption_QB
     */
    class StaticOption extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property string|null $unique_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_StaticOptionCentral_QB onWriteConnection()
     * @method _IH_StaticOptionCentral_QB newQuery()
     * @method static _IH_StaticOptionCentral_QB on(null|string $connection = null)
     * @method static _IH_StaticOptionCentral_QB query()
     * @method static _IH_StaticOptionCentral_QB with(array|string $relations)
     * @method _IH_StaticOptionCentral_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOptionCentral_C|StaticOptionCentral[] all()
     * @mixin _IH_StaticOptionCentral_QB
     */
    class StaticOptionCentral extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $deleted_at
     * @method static _IH_Status_QB onWriteConnection()
     * @method _IH_Status_QB newQuery()
     * @method static _IH_Status_QB on(null|string $connection = null)
     * @method static _IH_Status_QB query()
     * @method static _IH_Status_QB with(array|string $relations)
     * @method _IH_Status_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Status_C|Status[] all()
     * @foreignLinks id,\Modules\Product\Entities\Product,status_id|id,\Modules\Attributes\Entities\Category,status_id|id,\Modules\Attributes\Entities\SubCategory,status_id|id,\Modules\Attributes\Entities\ChildCategory,status_id|id,\Modules\DigitalProduct\Entities\DigitalProduct,status_id
     * @mixin _IH_Status_QB
     */
    class Status extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportDepartment_QB onWriteConnection()
     * @method _IH_SupportDepartment_QB newQuery()
     * @method static _IH_SupportDepartment_QB on(null|string $connection = null)
     * @method static _IH_SupportDepartment_QB query()
     * @method static _IH_SupportDepartment_QB with(array|string $relations)
     * @method _IH_SupportDepartment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportDepartment_C|SupportDepartment[] all()
     * @mixin _IH_SupportDepartment_QB
     */
    class SupportDepartment extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $via
     * @property string|null $operating_system
     * @property string|null $user_agent
     * @property string|null $description
     * @property string|null $subject
     * @property string|null $status
     * @property string|null $priority
     * @property int|null $department_id
     * @property int|null $user_id
     * @property int|null $admin_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin|null $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property SupportDepartment|null $department
     * @method BelongsTo|_IH_SupportDepartment_QB department()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SupportTicket_QB onWriteConnection()
     * @method _IH_SupportTicket_QB newQuery()
     * @method static _IH_SupportTicket_QB on(null|string $connection = null)
     * @method static _IH_SupportTicket_QB query()
     * @method static _IH_SupportTicket_QB with(array|string $relations)
     * @method _IH_SupportTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicket_C|SupportTicket[] all()
     * @ownLinks user_id,\App\Models\User,id|admin_id,\App\Models\Admin,id
     * @foreignLinks id,\App\Models\SupportTicketMessage,support_ticket_id
     * @mixin _IH_SupportTicket_QB
     */
    class SupportTicket extends Model {}
    
    /**
     * @property int $id
     * @property string|null $message
     * @property string|null $notify
     * @property string|null $attachment
     * @property string|null $type
     * @property int|null $user_id
     * @property int|null $support_ticket_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportTicketMessage_QB onWriteConnection()
     * @method _IH_SupportTicketMessage_QB newQuery()
     * @method static _IH_SupportTicketMessage_QB on(null|string $connection = null)
     * @method static _IH_SupportTicketMessage_QB query()
     * @method static _IH_SupportTicketMessage_QB with(array|string $relations)
     * @method _IH_SupportTicketMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicketMessage_C|SupportTicketMessage[] all()
     * @ownLinks user_id,\App\Models\User,id|support_ticket_id,\App\Models\SupportTicket,id
     * @mixin _IH_SupportTicketMessage_QB
     */
    class SupportTicketMessage extends Model {}
    
    /**
     * @property string $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property array|null $data
     * @property int|null $user_id
     * @property string|null $theme_slug
     * @property int|null $renew_status
     * @property int $is_renew
     * @property string|null $start_date
     * @property string|null $expire_date
     * @property string|null $unique_key
     * @property int $cleanup
     * @property CustomDomain $custom_domain
     * @method HasOne|_IH_CustomDomain_QB custom_domain()
     * @property UserDomain $domain
     * @method HasOne|_IH_UserDomain_QB domain()
     * @property _IH_Domain_C|Domain[] $domains
     * @property-read int $domains_count
     * @method HasMany|_IH_Domain_QB domains()
     * @property PaymentLogs $payment_log
     * @method HasOne|_IH_PaymentLogs_QB payment_log()
     * @property TenantUniqueKey $tenant_unique_key
     * @method HasOne|_IH_TenantUniqueKey_QB tenant_unique_key()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Tenant_QB onWriteConnection()
     * @method _IH_Tenant_QB newQuery()
     * @method static _IH_Tenant_QB on(null|string $connection = null)
     * @method static _IH_Tenant_QB query()
     * @method static _IH_Tenant_QB with(array|string $relations)
     * @method _IH_Tenant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tenant_C|Tenant[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\Stancl\Tenancy\Database\Models\Domain,tenant_id|id,\App\Models\TenantUniqueKey,tenant_id|id,\App\Models\PaymentLogs,tenant_id|id,\App\Models\TenantException,tenant_id|id,\Modules\Wallet\Entities\WalletTenantList,tenant_id
     * @mixin _IH_Tenant_QB
     */
    class Tenant extends Model {}
    
    /**
     * @property int $id
     * @property string $tenant_id
     * @property string|null $issue_type
     * @property string|null $description
     * @property int $domain_create_status
     * @property bool $seen_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Tenant $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @method static _IH_TenantException_QB onWriteConnection()
     * @method _IH_TenantException_QB newQuery()
     * @method static _IH_TenantException_QB on(null|string $connection = null)
     * @method static _IH_TenantException_QB query()
     * @method static _IH_TenantException_QB with(array|string $relations)
     * @method _IH_TenantException_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TenantException_C|TenantException[] all()
     * @ownLinks tenant_id,\App\Models\Tenant,id
     * @mixin _IH_TenantException_QB
     */
    class TenantException extends Model {}
    
    /**
     * @property int $id
     * @property string $tenant_id
     * @property string $unique_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Tenant $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_TenantUniqueKey_QB onWriteConnection()
     * @method _IH_TenantUniqueKey_QB newQuery()
     * @method static _IH_TenantUniqueKey_QB on(null|string $connection = null)
     * @method static _IH_TenantUniqueKey_QB query()
     * @method static _IH_TenantUniqueKey_QB with(array|string $relations)
     * @method _IH_TenantUniqueKey_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TenantUniqueKey_C|TenantUniqueKey[] all()
     * @ownLinks tenant_id,\App\Models\Tenant,id
     * @mixin _IH_TenantUniqueKey_QB
     */
    class TenantUniqueKey extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $designation
     * @property string $description
     * @property string|null $image
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $company
     * @method static _IH_Testimonial_QB onWriteConnection()
     * @method _IH_Testimonial_QB newQuery()
     * @method static _IH_Testimonial_QB on(null|string $connection = null)
     * @method static _IH_Testimonial_QB query()
     * @method static _IH_Testimonial_QB with(array|string $relations)
     * @method _IH_Testimonial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Testimonial_C|Testimonial[] all()
     * @mixin _IH_Testimonial_QB
     */
    class Testimonial extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string $slug
     * @property string|null $description
     * @property bool $status
     * @property bool $is_premium
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $unique_key
     * @property string|null $theme_url
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_Themes_QB onWriteConnection()
     * @method _IH_Themes_QB newQuery()
     * @method static _IH_Themes_QB on(null|string $connection = null)
     * @method static _IH_Themes_QB query()
     * @method static _IH_Themes_QB with(array|string $relations)
     * @method _IH_Themes_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Themes_C|Themes[] all()
     * @mixin _IH_Themes_QB
     */
    class Themes extends Model {}
    
    /**
     * @property int $id
     * @property string|null $icon
     * @property string|null $url
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TopbarInfo_QB onWriteConnection()
     * @method _IH_TopbarInfo_QB newQuery()
     * @method static _IH_TopbarInfo_QB on(null|string $connection = null)
     * @method static _IH_TopbarInfo_QB query()
     * @method static _IH_TopbarInfo_QB with(array|string $relations)
     * @method _IH_TopbarInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TopbarInfo_C|TopbarInfo[] all()
     * @mixin _IH_TopbarInfo_QB
     */
    class TopbarInfo extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $remember_token
     * @property string $username
     * @property bool $has_subdomain
     * @property int $email_verified
     * @property string|null $email_verify_token
     * @property string|null $mobile
     * @property string|null $company
     * @property string|null $address
     * @property string|null $city
     * @property string|null $state
     * @property string|null $country
     * @property int|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $api_token_plan_text
     * @property string|null $temp_password
     * @property Carbon|null $deleted_at
     * @property string|null $postal_code
     * @method HasOne|_IH_Country_QB country()
     * @property _IH_CustomDomain_C|CustomDomain[] $custom_domains
     * @property-read int $custom_domains_count
     * @method HasMany|_IH_CustomDomain_QB custom_domains()
     * @property UserDeliveryAddress $delivery_address
     * @method HasOne|_IH_UserDeliveryAddress_QB delivery_address()
     * @property _IH_UserDomain_C|UserDomain[] $domains
     * @property-read int $domains_count
     * @method HasMany|_IH_UserDomain_QB domains()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property UserOtp $otpInfo
     * @method HasOne|_IH_UserOtp_QB otpInfo()
     * @property _IH_PaymentLogs_C|PaymentLogs[] $payment_log
     * @property-read int $payment_log_count
     * @method HasMany|_IH_PaymentLogs_QB payment_log()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @method HasOne|_IH_State_QB state()
     * @property _IH_Tenant_C|Tenant[] $tenant_details
     * @property-read int $tenant_details_count
     * @method HasMany|_IH_Tenant_QB tenant_details()
     * @property Tenant $tenant_info
     * @method BelongsTo|_IH_Tenant_QB tenant_info()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property City|null $userCity
     * @method HasOne|_IH_City_QB userCity()
     * @property Country|null $userCountry
     * @method HasOne|_IH_Country_QB userCountry()
     * @property State|null $userState
     * @method HasOne|_IH_State_QB userState()
     * @property Wallet $wallet
     * @method HasOne|_IH_Wallet_QB wallet()
     * @property _IH_WalletTenantList_C|WalletTenantList[] $wallet_tenant_list
     * @property-read int $wallet_tenant_list_count
     * @method HasMany|_IH_WalletTenantList_QB wallet_tenant_list()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Models\ProductReviews,user_id|id,\App\Models\UserDeliveryAddress,user_id|id,\App\Models\ProductWishlist,user_id|id,\Modules\DigitalProduct\Entities\DigitalProductReviews,user_id|id,\App\Models\Tenant,user_id|id,\App\Models\Order,user_id|id,\App\Models\PaymentLogs,user_id|id,\App\Models\SupportTicket,user_id|id,\App\Models\SupportTicketMessage,user_id|id,\Modules\ShippingModule\Entities\ShippingAddress,user_id|id,\Modules\ShippingModule\Entities\UserShippingAddress,user_id|id,\Modules\Blog\Entities\BlogComment,user_id|id,\App\Models\MediaUploader,user_id|id,\Modules\Blog\Entities\Blog,user_id|id,\App\Models\CustomDomain,user_id|id,\App\Models\ProductOrder,user_id|id,\App\Models\OrderProducts,user_id|id,\Modules\Wallet\Entities\Wallet,user_id|id,\Modules\Wallet\Entities\WalletHistory,user_id|id,\Modules\Wallet\Entities\WalletSettings,user_id|id,\Modules\Wallet\Entities\WalletTenantList,user_id|id,\Modules\RefundModule\Entities\RefundProduct,user_id|id,\Modules\RefundModule\Entities\RefundChat,user_id|id,\Modules\RefundModule\Entities\RefundChatMessage,user_id|id,\App\Models\ZeroPricePlanHistory,user_id|id,\Modules\DigitalProduct\Entities\DigitalProductDownload,user_id|id,\Modules\SmsGateway\Entities\UserOtp,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $country_id
     * @property int|null $state_id
     * @property string|null $full_name
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $city
     * @property string|null $address
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $postal_code
     * @property City|null $city_rel
     * @method BelongsTo|_IH_City_QB city_rel()
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State|null $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_UserDeliveryAddress_QB onWriteConnection()
     * @method _IH_UserDeliveryAddress_QB newQuery()
     * @method static _IH_UserDeliveryAddress_QB on(null|string $connection = null)
     * @method static _IH_UserDeliveryAddress_QB query()
     * @method static _IH_UserDeliveryAddress_QB with(array|string $relations)
     * @method _IH_UserDeliveryAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserDeliveryAddress_C|UserDeliveryAddress[] all()
     * @ownLinks user_id,\App\Models\User,id|country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id
     * @mixin _IH_UserDeliveryAddress_QB
     */
    class UserDeliveryAddress extends Model {}
    
    /**
     * @property int $id
     * @property string $domain
     * @property string $tenant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserDomain_QB onWriteConnection()
     * @method _IH_UserDomain_QB newQuery()
     * @method static _IH_UserDomain_QB on(null|string $connection = null)
     * @method static _IH_UserDomain_QB query()
     * @method static _IH_UserDomain_QB with(array|string $relations)
     * @method _IH_UserDomain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserDomain_C|UserDomain[] all()
     * @ownLinks tenant_id,\App\Models\Tenant,id
     * @mixin _IH_UserDomain_QB
     */
    class UserDomain extends Model {}
    
    /**
     * @property int $id
     * @property string|null $widget_area
     * @property int|null $widget_order
     * @property string|null $widget_location
     * @property string $widget_name
     * @property string $widget_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $widget_namespace
     * @method static _IH_Widgets_QB onWriteConnection()
     * @method _IH_Widgets_QB newQuery()
     * @method static _IH_Widgets_QB on(null|string $connection = null)
     * @method static _IH_Widgets_QB query()
     * @method static _IH_Widgets_QB with(array|string $relations)
     * @method _IH_Widgets_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Widgets_C|Widgets[] all()
     * @mixin _IH_Widgets_QB
     */
    class Widgets extends Model {}
    
    /**
     * @property int $id
     * @property int|null $plan_id
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ZeroPricePlanHistory_QB onWriteConnection()
     * @method _IH_ZeroPricePlanHistory_QB newQuery()
     * @method static _IH_ZeroPricePlanHistory_QB on(null|string $connection = null)
     * @method static _IH_ZeroPricePlanHistory_QB query()
     * @method static _IH_ZeroPricePlanHistory_QB with(array|string $relations)
     * @method _IH_ZeroPricePlanHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ZeroPricePlanHistory_C|ZeroPricePlanHistory[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_ZeroPricePlanHistory_QB
     */
    class ZeroPricePlanHistory extends Model {}
}