<?php //72c9074427758a877a840d938fb2e23e
/** @noinspection all */

namespace Modules\WebHook\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_WebhookEvents_C;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_WebhookEvents_QB;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_WebhookLog_C;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_WebhookLog_QB;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_Webhook_C;
    use LaravelIdea\Helper\Modules\WebHook\Entities\_IH_Webhook_QB;

    /**
     * @property int $id
     * @property string $name
     * @property int $status
     * @property string $url
     * @property string $method_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_WebhookEvents_C|WebhookEvents[] $events
     * @property-read int $events_count
     * @method HasMany|_IH_WebhookEvents_QB events()
     * @method static _IH_Webhook_QB onWriteConnection()
     * @method _IH_Webhook_QB newQuery()
     * @method static _IH_Webhook_QB on(null|string $connection = null)
     * @method static _IH_Webhook_QB query()
     * @method static _IH_Webhook_QB with(array|string $relations)
     * @method _IH_Webhook_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Webhook_C|Webhook[] all()
     * @foreignLinks id,\Modules\WebHook\Entities\WebhookEvents,webhook_id
     * @mixin _IH_Webhook_QB
     */
    class Webhook extends Model {}

    /**
     * @property int $id
     * @property int $webhook_id
     * @property string $event_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Webhook $webhook
     * @method BelongsTo|_IH_Webhook_QB webhook()
     * @method static _IH_WebhookEvents_QB onWriteConnection()
     * @method _IH_WebhookEvents_QB newQuery()
     * @method static _IH_WebhookEvents_QB on(null|string $connection = null)
     * @method static _IH_WebhookEvents_QB query()
     * @method static _IH_WebhookEvents_QB with(array|string $relations)
     * @method _IH_WebhookEvents_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WebhookEvents_C|WebhookEvents[] all()
     * @ownLinks webhook_id,\Modules\WebHook\Entities\Webhook,id
     * @mixin _IH_WebhookEvents_QB
     */
    class WebhookEvents extends Model {}

    /**
     * @property int $id
     * @property string $event_name
     * @property string $method_type
     * @property string $url
     * @property string $payload
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_WebhookLog_QB onWriteConnection()
     * @method _IH_WebhookLog_QB newQuery()
     * @method static _IH_WebhookLog_QB on(null|string $connection = null)
     * @method static _IH_WebhookLog_QB query()
     * @method static _IH_WebhookLog_QB with(array|string $relations)
     * @method _IH_WebhookLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WebhookLog_C|WebhookLog[] all()
     * @mixin _IH_WebhookLog_QB
     */
    class WebhookLog extends Model {}
}
