<?php //8fbc0a2202b8a28ae4d2f6f164a5be36
/** @noinspection all */

namespace Modules\DigitalProduct\Entities {

    use App\Models\MediaUploader;
    use App\Models\MetaInfo;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\HasOneThrough;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_C;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_QB;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Badge\Entities\_IH_Badge_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_AdditionalCustomField_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_AdditionalCustomField_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_AdditionalField_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_AdditionalField_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalAuthor_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalAuthor_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalChildCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalChildCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalLanguage_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalLanguage_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductChildCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductChildCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductDownload_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductDownload_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductGallery_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductGallery_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductLanguage_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductLanguage_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductRefundPolicies_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductRefundPolicies_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductReviews_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductReviews_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductSubCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductSubCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductTags_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductTags_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductType_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProductType_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProduct_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalProduct_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalSubCategories_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalSubCategories_QB;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalTax_C;
    use LaravelIdea\Helper\Modules\DigitalProduct\Entities\_IH_DigitalTax_QB;
    use Modules\Badge\Entities\Badge;

    /**
     * @property int $id
     * @property int $additional_field_id
     * @property string $option_name
     * @property string $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AdditionalCustomField_QB onWriteConnection()
     * @method _IH_AdditionalCustomField_QB newQuery()
     * @method static _IH_AdditionalCustomField_QB on(null|string $connection = null)
     * @method static _IH_AdditionalCustomField_QB query()
     * @method static _IH_AdditionalCustomField_QB with(array|string $relations)
     * @method _IH_AdditionalCustomField_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdditionalCustomField_C|AdditionalCustomField[] all()
     * @ownLinks additional_field_id,\Modules\DigitalProduct\Entities\AdditionalField,id
     * @mixin _IH_AdditionalCustomField_QB
     */
    class AdditionalCustomField extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int|null $badge_id
     * @property int|null $pages
     * @property int|null $language
     * @property string|null $formats
     * @property string|null $words
     * @property string|null $tool_used
     * @property string|null $database_used
     * @property string|null $compatible_browsers
     * @property string|null $compatible_os
     * @property string|null $high_resolution
     * @property int|null $author_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DigitalAuthor|null $author
     * @method HasOne|_IH_DigitalAuthor_QB author()
     * @property Badge|null $badge
     * @method HasOne|_IH_Badge_QB badge()
     * @property DigitalLanguage|null $getLanguage
     * @method HasOne|_IH_DigitalLanguage_QB getLanguage()
     * @method HasOne|_IH_DigitalLanguage_QB language()
     * @method static _IH_AdditionalField_QB onWriteConnection()
     * @method _IH_AdditionalField_QB newQuery()
     * @method static _IH_AdditionalField_QB on(null|string $connection = null)
     * @method static _IH_AdditionalField_QB query()
     * @method static _IH_AdditionalField_QB with(array|string $relations)
     * @method _IH_AdditionalField_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AdditionalField_C|AdditionalField[] all()
     * @ownLinks badge_id,\Modules\Badge\Entities\Badge,id|author_id,\Modules\DigitalProduct\Entities\DigitalAuthor,id|product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id
     * @foreignLinks id,\Modules\DigitalProduct\Entities\AdditionalCustomField,additional_field_id
     * @mixin _IH_AdditionalField_QB
     */
    class AdditionalField extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property bool $status
     * @property int|null $image_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_AdditionalField_C|AdditionalField[] $additionalFields
     * @property-read int $additional_fields_count
     * @method HasMany|_IH_AdditionalField_QB additionalFields()
     * @method static _IH_DigitalAuthor_QB onWriteConnection()
     * @method _IH_DigitalAuthor_QB newQuery()
     * @method static _IH_DigitalAuthor_QB on(null|string $connection = null)
     * @method static _IH_DigitalAuthor_QB query()
     * @method static _IH_DigitalAuthor_QB with(array|string $relations)
     * @method _IH_DigitalAuthor_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalAuthor_C|DigitalAuthor[] all()
     * @foreignLinks id,\Modules\DigitalProduct\Entities\AdditionalField,author_id
     * @mixin _IH_DigitalAuthor_QB
     */
    class DigitalAuthor extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property int|null $digital_product_type
     * @property int|null $image_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property _IH_DigitalProduct_C|DigitalProduct[] $product
     * @property-read int $product_count
     * @method HasManyThrough|_IH_DigitalProduct_QB product()
     * @property DigitalProductType|null $product_type
     * @method HasOne|_IH_DigitalProductType_QB product_type()
     * @method static _IH_DigitalCategories_QB onWriteConnection()
     * @method _IH_DigitalCategories_QB newQuery()
     * @method static _IH_DigitalCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalCategories_QB query()
     * @method static _IH_DigitalCategories_QB with(array|string $relations)
     * @method _IH_DigitalCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalCategories_C|DigitalCategories[] all()
     * @mixin _IH_DigitalCategories_QB
     */
    class DigitalCategories extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property int $sub_category_id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property int|null $image_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property DigitalCategories $category
     * @method BelongsTo|_IH_DigitalCategories_QB category()
     * @property DigitalSubCategories $subcategory
     * @method BelongsTo|_IH_DigitalSubCategories_QB subcategory()
     * @method static _IH_DigitalChildCategories_QB onWriteConnection()
     * @method _IH_DigitalChildCategories_QB newQuery()
     * @method static _IH_DigitalChildCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalChildCategories_QB query()
     * @method static _IH_DigitalChildCategories_QB with(array|string $relations)
     * @method _IH_DigitalChildCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalChildCategories_C|DigitalChildCategories[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id|sub_category_id,\Modules\Attributes\Entities\SubCategory,id
     * @mixin _IH_DigitalChildCategories_QB
     */
    class DigitalChildCategories extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property bool $status
     * @property int|null $image_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalLanguage_QB onWriteConnection()
     * @method _IH_DigitalLanguage_QB newQuery()
     * @method static _IH_DigitalLanguage_QB on(null|string $connection = null)
     * @method static _IH_DigitalLanguage_QB query()
     * @method static _IH_DigitalLanguage_QB with(array|string $relations)
     * @method _IH_DigitalLanguage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalLanguage_C|DigitalLanguage[] all()
     * @mixin _IH_DigitalLanguage_QB
     */
    class DigitalLanguage extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string|null $summary
     * @property string|null $description
     * @property int $image_id
     * @property string|null $included_files
     * @property string|null $version
     * @property Carbon|null $release_date
     * @property Carbon|null $update_date
     * @property string|null $preview_link
     * @property int|null $quantity
     * @property string|null $accessibility
     * @property bool|null $is_licensable
     * @property int|null $tax
     * @property string $file
     * @property float $regular_price
     * @property float|null $sale_price
     * @property Carbon|null $free_date
     * @property Carbon|null $promotional_date
     * @property float|null $promotional_price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $status_id
     * @property Carbon|null $deleted_at
     * @property int $product_type
     * @property _IH_AdditionalCustomField_C|AdditionalCustomField[] $additionalCustomFields
     * @property-read int $additional_custom_fields_count
     * @method HasManyThrough|_IH_AdditionalCustomField_QB additionalCustomFields()
     * @property AdditionalField $additionalFields
     * @method HasOne|_IH_AdditionalField_QB additionalFields()
     * @property DigitalAuthor $author
     * @method HasOneThrough|_IH_DigitalAuthor_QB author()
     * @property DigitalCategories $category
     * @method HasOneThrough|_IH_DigitalCategories_QB category()
     * @property _IH_DigitalChildCategories_C|DigitalChildCategories[] $childCategory
     * @property-read int $child_category_count
     * @method HasManyThrough|_IH_DigitalChildCategories_QB childCategory()
     * @property _IH_DigitalProductDownload_C|DigitalProductDownload[] $downloads
     * @property-read int $downloads_count
     * @method HasMany|_IH_DigitalProductDownload_QB downloads()
     * @property _IH_MediaUploader_C|MediaUploader[] $gallery_images
     * @property-read int $gallery_images_count
     * @method HasManyThrough|_IH_MediaUploader_QB gallery_images()
     * @property DigitalTax|null $getTax
     * @method HasOne|_IH_DigitalTax_QB getTax()
     * @property MetaInfo $metaData
     * @method MorphToMany|_IH_MetaInfo_QB metaData()
     * @property DigitalProductCategories $product_category
     * @method HasOne|_IH_DigitalProductCategories_QB product_category()
     * @property _IH_DigitalProductChildCategories_C|DigitalProductChildCategories[] $product_child_category
     * @property-read int $product_child_category_count
     * @method HasMany|_IH_DigitalProductChildCategories_QB product_child_category()
     * @property DigitalProductSubCategories $product_sub_category
     * @method HasOne|_IH_DigitalProductSubCategories_QB product_sub_category()
     * @property _IH_DigitalProductReviews_C|DigitalProductReviews[] $ratings
     * @property-read int $ratings_count
     * @method HasMany|_IH_DigitalProductReviews_QB ratings()
     * @property DigitalProductRefundPolicies $refund_policy
     * @method HasOne|_IH_DigitalProductRefundPolicies_QB refund_policy()
     * @property _IH_DigitalProductReviews_C|DigitalProductReviews[] $reviews
     * @property-read int $reviews_count
     * @method HasMany|_IH_DigitalProductReviews_QB reviews()
     * @property DigitalSubCategories $subCategory
     * @method HasOneThrough|_IH_DigitalSubCategories_QB subCategory()
     * @property _IH_DigitalProductTags_C|DigitalProductTags[] $tag
     * @property-read int $tag_count
     * @method HasMany|_IH_DigitalProductTags_QB tag()
     * @method HasOne|_IH_DigitalTax_QB tax()
     * @method static _IH_DigitalProduct_QB onWriteConnection()
     * @method _IH_DigitalProduct_QB newQuery()
     * @method static _IH_DigitalProduct_QB on(null|string $connection = null)
     * @method static _IH_DigitalProduct_QB query()
     * @method static _IH_DigitalProduct_QB with(array|string $relations)
     * @method _IH_DigitalProduct_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProduct_C|DigitalProduct[] all()
     * @ownLinks tax,\Modules\DigitalProduct\Entities\DigitalTax,id|status_id,\App\Models\Status,id
     * @foreignLinks id,\Modules\DigitalProduct\Entities\AdditionalField,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductDownload,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductChildCategories,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductSubCategories,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductCategories,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductTags,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductRefundPolicies,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductGallery,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductLanguage,product_id|id,\Modules\DigitalProduct\Entities\DigitalProductReviews,product_id
     * @mixin _IH_DigitalProduct_QB
     */
    class DigitalProduct extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductCategories_QB onWriteConnection()
     * @method _IH_DigitalProductCategories_QB newQuery()
     * @method static _IH_DigitalProductCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductCategories_QB query()
     * @method static _IH_DigitalProductCategories_QB with(array|string $relations)
     * @method _IH_DigitalProductCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductCategories_C|DigitalProductCategories[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|category_id,\Modules\Attributes\Entities\Category,id
     * @mixin _IH_DigitalProductCategories_QB
     */
    class DigitalProductCategories extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $child_category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductChildCategories_QB onWriteConnection()
     * @method _IH_DigitalProductChildCategories_QB newQuery()
     * @method static _IH_DigitalProductChildCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductChildCategories_QB query()
     * @method static _IH_DigitalProductChildCategories_QB with(array|string $relations)
     * @method _IH_DigitalProductChildCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductChildCategories_C|DigitalProductChildCategories[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|child_category_id,\Modules\Attributes\Entities\ChildCategory,id
     * @mixin _IH_DigitalProductChildCategories_QB
     */
    class DigitalProductChildCategories extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $download_count
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @method static _IH_DigitalProductDownload_QB onWriteConnection()
     * @method _IH_DigitalProductDownload_QB newQuery()
     * @method static _IH_DigitalProductDownload_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductDownload_QB query()
     * @method static _IH_DigitalProductDownload_QB with(array|string $relations)
     * @method _IH_DigitalProductDownload_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductDownload_C|DigitalProductDownload[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|user_id,\App\Models\User,id
     * @mixin _IH_DigitalProductDownload_QB
     */
    class DigitalProductDownload extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $image_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductGallery_QB onWriteConnection()
     * @method _IH_DigitalProductGallery_QB newQuery()
     * @method static _IH_DigitalProductGallery_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductGallery_QB query()
     * @method static _IH_DigitalProductGallery_QB with(array|string $relations)
     * @method _IH_DigitalProductGallery_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductGallery_C|DigitalProductGallery[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id
     * @mixin _IH_DigitalProductGallery_QB
     */
    class DigitalProductGallery extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $language_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductLanguage_QB onWriteConnection()
     * @method _IH_DigitalProductLanguage_QB newQuery()
     * @method static _IH_DigitalProductLanguage_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductLanguage_QB query()
     * @method static _IH_DigitalProductLanguage_QB with(array|string $relations)
     * @method _IH_DigitalProductLanguage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductLanguage_C|DigitalProductLanguage[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|language_id,\App\Models\Language,id
     * @mixin _IH_DigitalProductLanguage_QB
     */
    class DigitalProductLanguage extends Model {}

    /**
     * @property int $id
     * @property int|null $product_id
     * @property string|null $refund_description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductRefundPolicies_QB onWriteConnection()
     * @method _IH_DigitalProductRefundPolicies_QB newQuery()
     * @method static _IH_DigitalProductRefundPolicies_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductRefundPolicies_QB query()
     * @method static _IH_DigitalProductRefundPolicies_QB with(array|string $relations)
     * @method _IH_DigitalProductRefundPolicies_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductRefundPolicies_C|DigitalProductRefundPolicies[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id
     * @mixin _IH_DigitalProductRefundPolicies_QB
     */
    class DigitalProductRefundPolicies extends Model {}

    /**
     * @property int $id
     * @property int|null $product_id
     * @property int|null $user_id
     * @property int|null $rating
     * @property string|null $review_text
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_DigitalProductReviews_QB onWriteConnection()
     * @method _IH_DigitalProductReviews_QB newQuery()
     * @method static _IH_DigitalProductReviews_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductReviews_QB query()
     * @method static _IH_DigitalProductReviews_QB with(array|string $relations)
     * @method _IH_DigitalProductReviews_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductReviews_C|DigitalProductReviews[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|user_id,\App\Models\User,id
     * @mixin _IH_DigitalProductReviews_QB
     */
    class DigitalProductReviews extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $sub_category_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalProductSubCategories_QB onWriteConnection()
     * @method _IH_DigitalProductSubCategories_QB newQuery()
     * @method static _IH_DigitalProductSubCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductSubCategories_QB query()
     * @method static _IH_DigitalProductSubCategories_QB with(array|string $relations)
     * @method _IH_DigitalProductSubCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductSubCategories_C|DigitalProductSubCategories[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id|sub_category_id,\Modules\Attributes\Entities\SubCategory,id
     * @mixin _IH_DigitalProductSubCategories_QB
     */
    class DigitalProductSubCategories extends Model {}

    /**
     * @property int $id
     * @property string $tag_name
     * @property int $product_id
     * @property string|null $type
     * @method static _IH_DigitalProductTags_QB onWriteConnection()
     * @method _IH_DigitalProductTags_QB newQuery()
     * @method static _IH_DigitalProductTags_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductTags_QB query()
     * @method static _IH_DigitalProductTags_QB with(array|string $relations)
     * @method _IH_DigitalProductTags_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductTags_C|DigitalProductTags[] all()
     * @ownLinks product_id,\Modules\DigitalProduct\Entities\DigitalProduct,id
     * @mixin _IH_DigitalProductTags_QB
     */
    class DigitalProductTags extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property string $product_type
     * @property int|null $image_id
     * @property bool $status
     * @property array $extensions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @method static _IH_DigitalProductType_QB onWriteConnection()
     * @method _IH_DigitalProductType_QB newQuery()
     * @method static _IH_DigitalProductType_QB on(null|string $connection = null)
     * @method static _IH_DigitalProductType_QB query()
     * @method static _IH_DigitalProductType_QB with(array|string $relations)
     * @method _IH_DigitalProductType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalProductType_C|DigitalProductType[] all()
     * @mixin _IH_DigitalProductType_QB
     */
    class DigitalProductType extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property string $name
     * @property string $slug
     * @property string|null $description
     * @property int|null $image_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property DigitalCategories $category
     * @method BelongsTo|_IH_DigitalCategories_QB category()
     * @method static _IH_DigitalSubCategories_QB onWriteConnection()
     * @method _IH_DigitalSubCategories_QB newQuery()
     * @method static _IH_DigitalSubCategories_QB on(null|string $connection = null)
     * @method static _IH_DigitalSubCategories_QB query()
     * @method static _IH_DigitalSubCategories_QB with(array|string $relations)
     * @method _IH_DigitalSubCategories_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalSubCategories_C|DigitalSubCategories[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @mixin _IH_DigitalSubCategories_QB
     */
    class DigitalSubCategories extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property float $tax_percentage
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DigitalTax_QB onWriteConnection()
     * @method _IH_DigitalTax_QB newQuery()
     * @method static _IH_DigitalTax_QB on(null|string $connection = null)
     * @method static _IH_DigitalTax_QB query()
     * @method static _IH_DigitalTax_QB with(array|string $relations)
     * @method _IH_DigitalTax_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalTax_C|DigitalTax[] all()
     * @foreignLinks id,\Modules\DigitalProduct\Entities\DigitalProduct,tax
     * @mixin _IH_DigitalTax_QB
     */
    class DigitalTax extends Model {}
}
