<?php

namespace App\Exceptions;

use GuzzleHttp\Middleware;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\URL;
use Monolog\Handler\IFTTTHandler;
use phpDocumentor\Reflection\Types\Array_;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {

        });
    }
    public function render($request, Throwable $e)
    {
        if($request->is('api/tenant/*') || $request->is('api/*')){
            $responseArray = [];
            $message =  $e->getMessage();
            $status_code = $e->getCode() >= 200 ? $e->getCode() : 500;

            $responseArray['message'] = $message;
            if (App::isLocal() || App::hasDebugModeEnabled()){
                $responseArray['file'] = $e->getFile();
                $responseArray['line'] = $e->getLine();
                $responseArray['trace'] = $e->getTrace();
            }
            return response()->json($responseArray,$status_code);
        }

        if(str_contains($e->getMessage() , 'Route [login]' )){
            if(tenant())
            {
                $prefix = 'tenant.';
            } else {
                $prefix = 'landlord.';
            }
            return redirect()->to(route($prefix.'user.login'))->with(['msg' => __('Cookie expired, Please login'),'type' => 'danger']);
        }

        return parent::render($request, $e); // TODO: Change the autogenerated stub
    }
}
