<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCampaignSoldProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('campaign_sold_products')){
            Schema::create('campaign_sold_products', function (Blueprint $table) {
                $table->id();
                $table->bigInteger('product_id')->nullable();
                $table->integer('sold_count')->nullable();
                $table->double('total_amount')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('campaign_sold_products');
    }
}
